/**
  ******************************************************************************
  * @file    py32f410_hal_msp.c
  * @author  MCU Application Team
  * @brief   This file provides code for the MSP Initialization
  *          and de-Initialization codes.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* External functions --------------------------------------------------------*/

/**
  * @brief Initialize global MSP
  */
void HAL_MspInit(void)
{
  __HAL_RCC_SYSCFG_CLK_ENABLE();
  __HAL_RCC_PWR_CLK_ENABLE();
}

/**
  * @brief Initialize TIM1 related MSP
  */
void HAL_PWM_PWM_MspInit(PWM_HandleTypeDef *hpwm)
{
  GPIO_InitTypeDef   GPIO_InitStruct = {0};
  /* Enable PWM1 clock */
  __HAL_RCC_PWM1_CLK_ENABLE();

  /* Enable GPIOA clock */
  __HAL_RCC_GPIOA_CLK_ENABLE();

  /* Enable GPIOC clock */
  __HAL_RCC_GPIOC_CLK_ENABLE();
 
  GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;        /* Alternate Function Push Pull Mode */
  GPIO_InitStruct.Pull = GPIO_PULLUP;            /* Pull up */
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_HIGH;
  
  /* Initialize GPIOA4 PWM1 CH1 */
  GPIO_InitStruct.Pin = GPIO_PIN_4;
  GPIO_InitStruct.Alternate = GPIO_AF10_PWM1;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);
  /* Initialize GPIOA2 PWM1 CH2*/
  GPIO_InitStruct.Pin = GPIO_PIN_2;
  GPIO_InitStruct.Alternate = GPIO_AF10_PWM1;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);
  /* Initialize GPIOC2 PWM1 CH3*/
  GPIO_InitStruct.Pin = GPIO_PIN_2;
  GPIO_InitStruct.Alternate = GPIO_AF10_PWM1;                                              
  HAL_GPIO_Init(GPIOC, &GPIO_InitStruct);
  /* Initialize GPIOC11 PWM1 CH4 */
  GPIO_InitStruct.Pin = GPIO_PIN_11;
  GPIO_InitStruct.Alternate = GPIO_AF10_PWM1;
  HAL_GPIO_Init(GPIOC, &GPIO_InitStruct);
}

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
